//	CDialogReplaceFile.c

#include "string.h"
#include "stdio.h"
#include "Utils.h"
#include "MainEvent.h"
#include "CDialog3Button.h"

#include "CDialogReplaceFile.h"

typedef struct {
	Dlog_ItemIDType			i_itemHit;
	Boolean					i_doneB;
} Dlog_ReplaceFileRec;

static	Boolean		ReplaceFile_S_CB(short buttonID, void *cbData)
{
	Dlog_ReplaceFileRec		*replaceFileRecP = (Dlog_ReplaceFileRec *)cbData;
	
	replaceFileRecP->i_itemHit	= buttonID;
	replaceFileRecP->i_doneB	= TRUE;
	
	//	hold option to do it to all files
	if (check_key_down(option_key)) {
	
		if (buttonID == kDlog_ReplaceFile_ItemID_REPLACE) {
			replaceFileRecP->i_itemHit = kDlog_ReplaceFile_ItemID_REPLACE_ALL;
	
		} else if (buttonID == kDlog_ReplaceFile_ItemID_SKIP) {
			replaceFileRecP->i_itemHit = kDlog_ReplaceFile_ItemID_SKIP_ALL;
		}
	}
	
	return TRUE;
}

Dlog_ItemIDType		DoReplaceFileDialog(char *fileNameZ)
{
	CDialog3Button			*dialogP;
	Dlog3ButtonParamRec		dialogParams;
	Dlog3ButtonRec			*buttonP;
	Dlog_ReplaceFileRec		replaceFileRec;
	
	replaceFileRec.i_itemHit	= kDlog_ReplaceFile_ItemID_CANCEL;
	replaceFileRec.i_doneB		= FALSE;
	
	strcpy(dialogParams.titleAC, "Replace File");
	
	sprintf(
		dialogParams.verbageAC, 
		"An item named %s already exists in this location, would you "
			"like to replace it with the one you're moving?  (Press "
			"'option' to operate on all future conflicts)", 
		fileNameZ);
	
	dialogParams.DoneCB = ReplaceFile_S_CB;
	dialogParams.cbData	= &replaceFileRec;

	buttonP = &dialogParams.buttonA[kDlog_ReplaceFile_ItemID_REPLACE];
	strcpy(buttonP->nameAC, "Replace");
	buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_1;
	buttonP->actionType		= Dlog_Action_NONE;
	buttonP->visibleB		= TRUE;
	buttonP->keyEquivChar	= 'R';

	buttonP = &dialogParams.buttonA[kDlog_ReplaceFile_ItemID_CANCEL];
	strcpy(buttonP->nameAC, "Cancel");
	buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_2;
	buttonP->actionType		= Dlog_Action_CANCEL;
	buttonP->visibleB		= TRUE;
	buttonP->keyEquivChar	= 0;

	buttonP = &dialogParams.buttonA[kDlog_ReplaceFile_ItemID_SKIP];
	strcpy(buttonP->nameAC, "Skip");
	buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_3;
	buttonP->actionType		= Dlog_Action_DEFAULT;
	buttonP->visibleB		= TRUE;
	buttonP->keyEquivChar	= 0;
	
	dialogP = Show3ButtonDialog(&dialogParams);
	if (dialogP) {
		do {
			HandleOneEvent(10);
		} while (!replaceFileRec.i_doneB);
		
		//	already disposed;
		//	dialogP->Dispose();
	}
	
	return replaceFileRec.i_itemHit;
}
